/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.mrp2.CrDemand;
import cz.insophy.inplan.mrp2.Demand;
import cz.insophy.inplan.mrp2.ExtSupply;
import cz.insophy.inplan.mrp2.GorDemand;
import cz.insophy.inplan.mrp2.GorSupply;
import cz.insophy.inplan.mrp2.MaterialChanges;
import cz.insophy.inplan.mrp2.MaterialChangesCollector;
import cz.insophy.inplan.mrp2.SrSupply;
import cz.insophy.inplan.mrp2.SsDemand;
import cz.insophy.inplan.mrp2.Supply;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.superplan.Superplan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;

public class DefaultMaterialChangesCollector
implements MaterialChangesCollector {
    protected static final Object EXT_KEY = new Object();

    @Override
    @Nonnull
    public MaterialChanges collect(@Nonnull Superplan superplan, @Nonnull Product p) {
        Multimap<Object, StoreActivity> s2 = this.groupSasByOriginator(superplan, p);
        ArrayList<Supply> supplies = Lists.newArrayList();
        ArrayList<Demand> demands = Lists.newArrayList();
        for (Map.Entry<Object, Collection<StoreActivity>> entry : s2.asMap().entrySet()) {
            Object key = entry.getKey();
            double totalQty = 0.0;
            for (StoreActivity sa : entry.getValue()) {
                if (totalQty != 0.0) {
                    Preconditions.checkState(totalQty > 0.0 && sa.getQty() > 0.0 || totalQty < 0.0 && sa.getQty() < 0.0, "%s doesn't have the same sign as others in its group.", (Object)sa);
                }
                totalQty += sa.getQty();
            }
            if (totalQty > 1.0E-7) {
                supplies.add(this.createSupply(key, p, totalQty));
                continue;
            }
            if (!(totalQty < -1.0E-7)) continue;
            demands.add(this.createDemand(key, p, totalQty));
        }
        if (p.getSafetyStock() > 0.0) {
            demands.add(new SsDemand(p));
        }
        return new MaterialChanges(p, supplies, demands);
    }

    protected Demand createDemand(Object key, @Nonnull Product p, double totalQty) {
        Demand demand;
        if (key instanceof GeneralizedOrderRequest) {
            demand = new GorDemand((GeneralizedOrderRequest)key, p, -totalQty);
        } else if (key instanceof CustomerRequest) {
            demand = new CrDemand((CustomerRequest)key);
        } else {
            throw new IllegalStateException("Unknown demand source " + key);
        }
        return demand;
    }

    protected Supply createSupply(Object key, @Nonnull Product p, double totalQty) {
        Supply supply;
        if (key == EXT_KEY) {
            supply = new ExtSupply(p, totalQty);
        } else if (key instanceof GeneralizedOrderRequest) {
            supply = new GorSupply((GeneralizedOrderRequest)key, totalQty);
        } else if (key instanceof SupplyRequest) {
            supply = new SrSupply((SupplyRequest)key);
        } else {
            throw new IllegalStateException("Unknown supply source " + key);
        }
        return supply;
    }

    protected Multimap<Object, StoreActivity> groupSasByOriginator(@Nonnull Superplan superplan, @Nonnull Product p) {
        StoreSchedule ss = superplan.getPlan().getStoreSchedule(StoreType.POSSIBLE_ESTIMATE_VIEW);
        HashMultimap<Object, StoreActivity> s2 = HashMultimap.create();
        for (StoreActivity sa : ss.getActivities(p)) {
            Object key = sa.getOriginator();
            if (key == null) {
                key = EXT_KEY;
            } else if (key instanceof ProductionTreeNode) {
                key = ProductionTreeAlgorithms.getNearestGor((ProductionTreeNode)key);
            }
            s2.put(key, sa);
        }
        return s2;
    }
}

